/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.util.ArrayList;
import java.util.List;
import org.easymock.internal.ExpectedInvocation;
import org.easymock.internal.ExpectedInvocationAndResults;
import org.easymock.internal.Invocation;
import org.easymock.internal.Range;
import org.easymock.internal.Result;
import org.easymock.internal.Results;

public class UnorderedBehavior {
    private final List<ExpectedInvocationAndResults> results = new ArrayList<ExpectedInvocationAndResults>();
    private final boolean checkOrder;

    public UnorderedBehavior(boolean checkOrder) {
        this.checkOrder = checkOrder;
    }

    public void addExpected(ExpectedInvocation expected, Result result, Range count) {
        for (ExpectedInvocationAndResults entry : this.results) {
            if (!entry.getExpectedInvocation().equals(expected)) continue;
            entry.getResults().add(result, count);
            return;
        }
        Results list = new Results();
        list.add(result, count);
        this.results.add(new ExpectedInvocationAndResults(expected, list));
    }

    public Result addActual(Invocation actual) {
        for (ExpectedInvocationAndResults entry : this.results) {
            Result result;
            if (!entry.getExpectedInvocation().matches(actual) || (result = entry.getResults().next()) == null) continue;
            return result;
        }
        return null;
    }

    public boolean verify() {
        for (ExpectedInvocationAndResults entry : this.results) {
            if (entry.getResults().hasValidCallCount()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(Invocation invocation) {
        StringBuffer result = new StringBuffer();
        for (ExpectedInvocationAndResults entry : this.results) {
            boolean match;
            boolean unordered = !this.checkOrder;
            boolean validCallCount = entry.getResults().hasValidCallCount();
            boolean bl = match = invocation != null && entry.getExpectedInvocation().matches(invocation);
            if (unordered && validCallCount && !match) continue;
            result.append("\n    " + entry.toString());
            if (!match) continue;
            result.append(" (+1)");
        }
        return result.toString();
    }

    public boolean allowsExpectedInvocation(ExpectedInvocation expected, boolean checkOrder) {
        if (this.checkOrder != checkOrder) {
            return false;
        }
        if (this.results.isEmpty() || !this.checkOrder) {
            return true;
        }
        ExpectedInvocation lastMethodCall = this.results.get(this.results.size() - 1).getExpectedInvocation();
        return lastMethodCall.equals(expected);
    }
}

