/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.transaction.compensating;

import javax.naming.Name;
import javax.naming.directory.DirContext;
import javax.naming.ldap.LdapContext;
import org.apache.commons.lang.StringUtils;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.util.Assert;

public final class LdapTransactionUtils {
    public static final String REBIND_METHOD_NAME = "rebind";
    public static final String BIND_METHOD_NAME = "bind";
    public static final String RENAME_METHOD_NAME = "rename";
    public static final String UNBIND_METHOD_NAME = "unbind";
    public static final String MODIFY_ATTRIBUTES_METHOD_NAME = "modifyAttributes";
    static /* synthetic */ Class class$javax$naming$ldap$LdapContext;
    static /* synthetic */ Class class$javax$naming$directory$DirContext;

    private LdapTransactionUtils() {
    }

    public static Name getFirstArgumentAsName(Object[] args) {
        Assert.notEmpty((Object[])args);
        Object firstArg = args[0];
        return LdapTransactionUtils.getArgumentAsName(firstArg);
    }

    public static Name getArgumentAsName(Object arg) {
        if (arg instanceof String) {
            return new DistinguishedName((String)arg);
        }
        if (arg instanceof Name) {
            return (Name)arg;
        }
        throw new IllegalArgumentException("First argument needs to be a Name or a String representation thereof");
    }

    public static boolean isSupportedWriteTransactionOperation(String methodName) {
        return StringUtils.equals((String)methodName, (String)BIND_METHOD_NAME) || StringUtils.equals((String)methodName, (String)REBIND_METHOD_NAME) || StringUtils.equals((String)methodName, (String)RENAME_METHOD_NAME) || StringUtils.equals((String)methodName, (String)MODIFY_ATTRIBUTES_METHOD_NAME) || StringUtils.equals((String)methodName, (String)UNBIND_METHOD_NAME);
    }

    public static Class getActualTargetClass(DirContext context) {
        if (context instanceof LdapContext) {
            return class$javax$naming$ldap$LdapContext == null ? (class$javax$naming$ldap$LdapContext = LdapTransactionUtils.class$("javax.naming.ldap.LdapContext")) : class$javax$naming$ldap$LdapContext;
        }
        return class$javax$naming$directory$DirContext == null ? (class$javax$naming$directory$DirContext = LdapTransactionUtils.class$("javax.naming.directory.DirContext")) : class$javax$naming$directory$DirContext;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

