/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.transaction.compensating;

import javax.naming.Name;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.ldap.core.LdapOperations;
import org.springframework.transaction.compensating.CompensatingTransactionOperationExecutor;

public class UnbindOperationExecutor
implements CompensatingTransactionOperationExecutor {
    private static Log log = LogFactory.getLog((Class)(class$org$springframework$ldap$transaction$compensating$UnbindOperationExecutor == null ? (class$org$springframework$ldap$transaction$compensating$UnbindOperationExecutor = UnbindOperationExecutor.class$("org.springframework.ldap.transaction.compensating.UnbindOperationExecutor")) : class$org$springframework$ldap$transaction$compensating$UnbindOperationExecutor));
    private LdapOperations ldapOperations;
    private Name originalDn;
    private Name temporaryDn;
    static /* synthetic */ Class class$org$springframework$ldap$transaction$compensating$UnbindOperationExecutor;

    public UnbindOperationExecutor(LdapOperations ldapOperations, Name originalDn, Name temporaryDn) {
        this.ldapOperations = ldapOperations;
        this.originalDn = originalDn;
        this.temporaryDn = temporaryDn;
    }

    public void rollback() {
        try {
            this.ldapOperations.rename(this.temporaryDn, this.originalDn);
        }
        catch (Exception e) {
            log.warn((Object)("Filed to rollback unbind operation, temporaryDn: " + this.temporaryDn + "; originalDn: " + this.originalDn));
        }
    }

    public void commit() {
        log.debug((Object)"Committing unbind operation - unbinding temporary entry");
        this.ldapOperations.unbind(this.temporaryDn);
    }

    public void performOperation() {
        log.debug((Object)"Performing operation for unbind - renaming to temporary entry.");
        this.ldapOperations.rename(this.originalDn, this.temporaryDn);
    }

    LdapOperations getLdapOperations() {
        return this.ldapOperations;
    }

    Name getOriginalDn() {
        return this.originalDn;
    }

    Name getTemporaryDn() {
        return this.temporaryDn;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

