/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.compensating.support;

import java.util.Iterator;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.compensating.CompensatingTransactionOperationExecutor;
import org.springframework.transaction.compensating.CompensatingTransactionOperationFactory;
import org.springframework.transaction.compensating.CompensatingTransactionOperationManager;
import org.springframework.transaction.compensating.CompensatingTransactionOperationRecorder;

public class DefaultCompensatingTransactionOperationManager
implements CompensatingTransactionOperationManager {
    private static Log log = LogFactory.getLog((Class)(class$org$springframework$transaction$compensating$support$DefaultCompensatingTransactionOperationManager == null ? (class$org$springframework$transaction$compensating$support$DefaultCompensatingTransactionOperationManager = DefaultCompensatingTransactionOperationManager.class$("org.springframework.transaction.compensating.support.DefaultCompensatingTransactionOperationManager")) : class$org$springframework$transaction$compensating$support$DefaultCompensatingTransactionOperationManager));
    private Stack operationExecutors = new Stack();
    private CompensatingTransactionOperationFactory operationFactory;
    static /* synthetic */ Class class$org$springframework$transaction$compensating$support$DefaultCompensatingTransactionOperationManager;

    public DefaultCompensatingTransactionOperationManager(CompensatingTransactionOperationFactory operationFactory) {
        this.operationFactory = operationFactory;
    }

    public void performOperation(Object resource, String operation, Object[] args) {
        CompensatingTransactionOperationRecorder recorder = this.operationFactory.createRecordingOperation(resource, operation);
        CompensatingTransactionOperationExecutor executor = recorder.recordOperation(args);
        executor.performOperation();
        this.operationExecutors.push(executor);
    }

    public void rollback() {
        log.debug((Object)"Performing rollback");
        while (!this.operationExecutors.isEmpty()) {
            CompensatingTransactionOperationExecutor rollbackOperation = (CompensatingTransactionOperationExecutor)this.operationExecutors.pop();
            try {
                rollbackOperation.rollback();
            }
            catch (Exception e) {
                throw new TransactionSystemException("Error occurred during rollback", (Throwable)e);
            }
        }
    }

    protected Stack getOperationExecutors() {
        return this.operationExecutors;
    }

    void setOperationExecutors(Stack operationExecutors) {
        this.operationExecutors = operationExecutors;
    }

    public void commit() {
        log.debug((Object)"Performing rollback");
        Iterator iter = this.operationExecutors.iterator();
        while (iter.hasNext()) {
            CompensatingTransactionOperationExecutor operationExecutor = (CompensatingTransactionOperationExecutor)iter.next();
            try {
                operationExecutor.commit();
            }
            catch (Exception e) {
                throw new TransactionSystemException("Error occurred during commit", (Throwable)e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

