/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.providers.cas;

import java.io.Serializable;
import org.jasig.cas.client.validation.Assertion;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.providers.AbstractAuthenticationToken;
import org.springframework.security.userdetails.UserDetails;

public class CasAuthenticationToken
extends AbstractAuthenticationToken
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Object credentials;
    private final Object principal;
    private final UserDetails userDetails;
    private final int keyHash;
    private final Assertion assertion;

    public CasAuthenticationToken(String key, Object principal, Object credentials, GrantedAuthority[] authorities, UserDetails userDetails, Assertion assertion) {
        super(authorities);
        if (key == null || "".equals(key) || principal == null || "".equals(principal) || credentials == null || "".equals(credentials) || authorities == null || userDetails == null || assertion == null) {
            throw new IllegalArgumentException("Cannot pass null or empty values to constructor");
        }
        this.keyHash = key.hashCode();
        this.principal = principal;
        this.credentials = credentials;
        this.userDetails = userDetails;
        this.assertion = assertion;
        this.setAuthenticated(true);
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (obj instanceof CasAuthenticationToken) {
            CasAuthenticationToken test = (CasAuthenticationToken)obj;
            if (!this.assertion.equals(test.getAssertion())) {
                return false;
            }
            return this.getKeyHash() == test.getKeyHash();
        }
        return false;
    }

    public Object getCredentials() {
        return this.credentials;
    }

    public int getKeyHash() {
        return this.keyHash;
    }

    public Object getPrincipal() {
        return this.principal;
    }

    public Assertion getAssertion() {
        return this.assertion;
    }

    public UserDetails getUserDetails() {
        return this.userDetails;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append(" Assertion: ").append(this.assertion);
        sb.append(" Credentials (Service/Proxy Ticket): ").append(this.credentials);
        return sb.toString();
    }
}

