/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.transaction.compensating;

import javax.naming.Name;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.ldap.core.LdapOperations;
import org.springframework.ldap.transaction.compensating.LdapTransactionUtils;
import org.springframework.ldap.transaction.compensating.RenameOperationExecutor;
import org.springframework.transaction.compensating.CompensatingTransactionOperationExecutor;
import org.springframework.transaction.compensating.CompensatingTransactionOperationRecorder;
import org.springframework.util.Assert;

public class RenameOperationRecorder
implements CompensatingTransactionOperationRecorder {
    private static Log log = LogFactory.getLog((Class)(class$org$springframework$ldap$transaction$compensating$RenameOperationRecorder == null ? (class$org$springframework$ldap$transaction$compensating$RenameOperationRecorder = RenameOperationRecorder.class$("org.springframework.ldap.transaction.compensating.RenameOperationRecorder")) : class$org$springframework$ldap$transaction$compensating$RenameOperationRecorder));
    private LdapOperations ldapOperations;
    static /* synthetic */ Class class$org$springframework$ldap$transaction$compensating$RenameOperationRecorder;

    public RenameOperationRecorder(LdapOperations ldapOperations) {
        this.ldapOperations = ldapOperations;
    }

    public CompensatingTransactionOperationExecutor recordOperation(Object[] args) {
        log.debug((Object)"Storing rollback information for rename operation");
        Assert.notEmpty((Object[])args);
        if (args.length != 2) {
            throw new IllegalArgumentException("Illegal argument length");
        }
        Name oldDn = LdapTransactionUtils.getArgumentAsName(args[0]);
        Name newDn = LdapTransactionUtils.getArgumentAsName(args[1]);
        return new RenameOperationExecutor(this.ldapOperations, oldDn, newDn);
    }

    LdapOperations getLdapOperations() {
        return this.ldapOperations;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

