/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.resolve;

import java.util.Vector;
import org.openxri.XRIAuthority;
import org.openxri.resolve.CacheNode;
import org.openxri.resolve.CacheResult;
import org.openxri.xml.XRD;
import org.openxri.xml.XRDS;

public class Cache {
    CacheNode moRootNode = new CacheNode(this);
    private int mnNodes = 0;
    private int mnMaxSize = 1000;

    Cache(int nSize) {
        this.mnMaxSize = nSize;
    }

    synchronized int increment() {
        ++this.mnNodes;
        return this.mnNodes;
    }

    synchronized int decrement() {
        --this.mnNodes;
        return this.mnNodes;
    }

    public synchronized int getNumNodes() {
        return this.mnNodes;
    }

    public synchronized void setMaxSize(int nVal) {
        this.mnMaxSize = nVal;
    }

    public synchronized int getMaxSize() {
        return this.mnMaxSize;
    }

    CachedValue find(XRIAuthority oAuth, boolean bPartial) {
        return this.find(oAuth, bPartial, false, null);
    }

    CachedValue find(XRIAuthority oAuth, boolean bPartial, boolean bCompleteChain, Vector oCachedDescriptors) {
        CacheNode oNode = this.findNode(oAuth, bPartial, bCompleteChain, oCachedDescriptors);
        return oNode != null ? oNode.moCacheValue : null;
    }

    private CacheNode findNode(XRIAuthority oAuth, boolean bPartial, boolean bCompleteChain, Vector oCachedDescriptors) {
        CacheNode oCommunityNode = this.moRootNode.find(oAuth.getRootAuthority());
        if (oCommunityNode == null) {
            return null;
        }
        if (oCommunityNode.moCacheValue == null || oCommunityNode.moCacheValue.getDescriptor() == null) {
            if (bCompleteChain) {
                return null;
            }
        } else if (oCachedDescriptors != null) {
            oCachedDescriptors.add(oCommunityNode.moCacheValue.getDescriptor());
        }
        CacheResult oDeepestNode = oCommunityNode.find(oAuth, 0, bCompleteChain, oCachedDescriptors);
        if (bPartial || oDeepestNode.mnNumFound == oAuth.getNumSubSegments()) {
            return oDeepestNode.moLastCacheNode;
        }
        return null;
    }

    synchronized void stuff(XRIAuthority oAuth, XRD oDescriptor) {
        this.stuff(oAuth, oDescriptor, oAuth.getNumSubSegments());
    }

    public void stuff(XRIAuthority oAuth, XRDS oDescriptors) {
        for (int i = 0; i < oDescriptors.getNumChildren(); ++i) {
            this.stuff(oAuth, oDescriptors.getDescriptorAt(i), i);
        }
    }

    synchronized void stuff(XRIAuthority oAuth, XRD oDescriptor, int nDepth) {
        CacheNode oCommunityNode = this.moRootNode.mkdir(oAuth.getRootAuthority());
        CacheNode oNode = oCommunityNode.mkdir(oAuth, 0, nDepth);
        oNode.moCacheValue = new CachedValue(oDescriptor, nDepth);
        this.trim();
    }

    synchronized void trim() {
        while (this.mnNodes > this.mnMaxSize) {
            CacheNode oNode = this.moRootNode.moPrev;
            while (oNode.moParent == this.moRootNode) {
                oNode = oNode.moPrev;
            }
            if (oNode == this.moRootNode) {
                return;
            }
            oNode.removeSelf(true);
        }
    }

    synchronized boolean prune(XRIAuthority oAuth) {
        CacheNode oNode = this.findNode(oAuth, false, false, null);
        return oNode == null ? false : oNode.removeSelf(true);
    }

    synchronized void dump() {
        System.out.println("Num nodes = " + this.mnNodes);
        CacheNode oNode = this.moRootNode.moNext;
        int i = 1;
        while (oNode != this.moRootNode) {
            System.out.println("#" + i + "\t" + oNode.msSubsegment);
            oNode = oNode.moNext;
            ++i;
        }
    }

    public class CachedValue {
        private XRD moDescriptor;
        private int mnDepth = 0;

        CachedValue(XRD oDesc, int nDepth) {
            this.moDescriptor = oDesc;
            this.mnDepth = nDepth;
        }

        public int getDepth() {
            return this.mnDepth;
        }

        public XRD getDescriptor() {
            return this.moDescriptor != null && this.moDescriptor.isValid() ? this.moDescriptor : null;
        }

        public String toString() {
            return this.moDescriptor.toString();
        }
    }
}

