class Task {
    TaskGroup taskGroup
    TaskStatus taskStatus
    Person leadPerson
    String description
    String comment = ""
    Date targetStartDate = new Date()
    Date targetCompletionDate = new Date()
    boolean isScheduled = false
    boolean isApproved = false
    boolean isActive = true

    static hasMany = [entries: Entry, modifications: Modification, assignedPersons: Person]

    static belongsTo = [TaskGroup, TaskStatus, Person]

    static constraints = {
        targetStartDate()
        description(blank:false,maxSize:50)
        leadPerson()
        taskStatus()
        comment(maxSize:255)
    }

    String toString() {"${this.description}"}
}
